<?php
/**
 * @file
 * Contains Login Settings for miniOrange OAuth Login Module.
 */
 /**
 * Showing Settings form.
 */
 function miniorange_oauth_login_options($form, &$form_state) {

     drupal_add_css( drupal_get_path('module', 'oauth_login_oauth2'). '/css/bootstrap.min.css' , array('group' => CSS_DEFAULT, 'every_page' => FALSE));
     drupal_add_css( drupal_get_path('module', 'oauth_login_oauth2'). '/css/style_settings.css' , array('group' => CSS_DEFAULT, 'every_page' => FALSE));
     drupal_add_js(drupal_get_path('module', 'oauth_login_oauth2') . '/js/slide_support_button.js');

     global $base_url;
     $baseUrlValue = variable_get('miniorange_oauth_client_base_url');
    $form['header_top_style_1'] = array('#markup' => '<div class="mo_oauth_table_layout_1">');

    $form['markup_top'] = array(
         '#markup' => '<div class="mo_oauth_table_layout mo_oauth_container">',
    );

    $form['markup_top_vt_start'] = array(
         '#markup' => '<b><span style="font-size: 17px;">Sign in Settings</span></b><br><hr><br/>'
     );

     $form['miniorange_oauth_client_base_url'] = array(
          '#type' => 'checkbox',
         '#title' => t('Enforce HTTPS Callback/Redirect'),
         '#default_value' => variable_get('miniorange_oauth_client_enforce_https_checkbox'),
         '#attributes' => array('id'=>'mo_oauth_vt_baseurl','placeholder' => 'Enter Base URL'),
         '#description' => '<b>Note: </b>Check this option if the OAuth Provider only support HTTPS Callback URL and you have an HTTP site.',
         '#suffix' => '<br>',
     );

     $form['miniorange_oauth_client_siginin_update_base'] = array(
        '#type' => 'submit',
        '#value' => t('Update'),
        '#submit' => array('miniorange_oauth_save_signin_settings'),
        '#suffix' => '<br><br>',
    );

     $form['markup_bottom_vt_start4'] = array(
         '#markup' => '<b><span style="font-size: 17px;">Advanced Sign in Settings <a href="' . $base_url . '/admin/config/people/oauth_login_oauth2/licensing"><b>[Premium, Enterprise]</b></a></span></b><br><hr><br/>'
    );

    $form['miniorange_oauth_force_auth'] = array(
        '#type' => 'checkbox',
        '#title' => t('Protect website against anonymous access'),
        '#disabled' => TRUE,
        '#description' => t('<b>Note: </b>Users will be redirected to your OAuth server for login in case user is not logged in and tries to access website.<br><br>'),
    );
    $form['miniorange_oauth_auto_redirect'] = array(
        '#type' => 'checkbox',
        '#title' => t('Check this option if you want to <b>replace Drupal login form with IDP/OAuth Provider login from</b>'),
        '#disabled' => TRUE,
        '#description' => t('<b>Note: </b>Users will be redirected to your OAuth server for login when the login page is accessed.<br><br>'),
    );
    $form['miniorange_oauth_enable_backdoor'] = array(
        '#type' => 'checkbox',
        '#title' => t('Check this option if you want to enable <b>backdoor login </b>'),
        '#disabled' => TRUE,
        '#description' => t('<b>Note</b>: Checking this option creates a backdoor to login to your Website using Drupal credentials<br> incase you get locked out of your OAuth server.
                <br><br>'),
    );

     $form['markup_bottom_vt_start'] = array(
         '#markup' => '<br><b><span style="font-size: 17px;">Domain & Page Restriction<a href="' . $base_url . '/admin/config/people/oauth_login_oauth2/licensing"><b> [Enterprise]</b></a></span> </b><br><hr><br/>'
     );

     $form['miniorange_oauth_client_allowed_domains'] = array(
         '#type' => 'textfield',
         '#title' => t('Allowed Domains'),
         '#attributes' => array('style' => 'width:73%','placeholder' => 'Enter semicolon(;) separated domains (Eg. xxxx.com; xxxx.com)'),
         '#description' => t('<b>Note: </b> Enter <b>semicolon(;) separated</b> domains to allow SSO. Other than these domains will not be allowed to do SSO.'),
         '#disabled' => TRUE,
     );

     $form['miniorange_oauth_client_restricted_domains_field'] = array(
         '#type' => 'textfield',
         '#title' => t('Restricted Domains'),
         '#attributes' => array('style' => 'width:73%','placeholder' => 'Enter semicolon(;) separated domains (Eg. xxxx.com; xxxx.com)'),
         '#description' => t('<b>Note: </b> Enter <b>semicolon(;) separated</b> domains to restrict SSO. Other than these domains will be allowed to do SSO.'),
         '#disabled' => TRUE,
     );

     $form['miniorange_oauth_client_page_restrict_url'] = array(
         '#type' => 'textfield',
         '#title' => t('Page Restriction'),
         '#attributes' => array('style' => 'width:73%','placeholder' => 'Enter semicolon(;) separated page URLs (Eg. xxxx.com/yyy; xxxx.com/yyy)'),
         '#description' => t('<b>Note: </b> Enter <b>semicolon(;) separated</b> URLs to restrict anonymous access.'),
         '#disabled' => TRUE,
     );

   $form['markup_role_signin'] = array(
     '#markup' => '<br><h3>Customize Redirection after SSO login and logout <a href="' . $base_url . '/admin/config/people/oauth_login_oauth2/licensing"><b>[Premium, Enterprise]</b></a></h3><hr><br>'
   );

   $form['miniorange_oauth_client_login_url'] = array(
     '#type' => 'textfield',
     '#title'=> t('Redirect URL after login'),
     '#id' => 'text_field',
     '#required' => FALSE,
     '#disabled' => TRUE,
     '#attributes' => array('style' => 'width:73%;','placeholder' => 'Enter Login URL'),
   );
   $form['miniorange_oauth_client_logout_url'] = array(
     '#type' => 'textfield',
     '#title'=> t('Redirect URL after logout'),
     '#id' => 'text_field',
     '#required' => FALSE,
     '#disabled' => TRUE,
     '#attributes' => array('style' => 'width:73%;','placeholder' => 'Enter Logout URL'),
   );



   $form['miniorange_oauth_client_siginin'] = array(
            '#type' => 'button',
            '#value' => t('Save Configuration'),
            '#disabled' => TRUE,
        );
    $form['mo_header_style_end'] = array('#markup' => '</div>');
     Utilities::spConfigGuide($form, $form_state);
     $form['mo_markup_div_imp']=array('#markup'=>'</div>');
     Utilities::AddSupportButton($form, $form_state);
     return $form;
 }

 /**
  * This function saves the values in the Sign in Settings tab.
  */
function miniorange_oauth_save_signin_settings($form, &$form_state) {
  $baseUrlCheckbox = $form['miniorange_oauth_client_base_url']['#value'];
  global $base_url;
  if($baseUrlCheckbox) {
    $baseUrlValue =  str_replace("http://", "https://", $base_url);
    variable_set('miniorange_oauth_client_base_url', $baseUrlValue);
    $miniorange_auth_client_callback_uri = $baseUrlValue."/?q=mo_login";
  }else{
    variable_set('miniorange_oauth_client_base_url', '');
    $miniorange_auth_client_callback_uri = $base_url."/?q=mo_login";

  }
  $appValue = variable_get('miniorange_oauth_client_appval');
  $appValue['callback_uri'] = $miniorange_auth_client_callback_uri;
  variable_set('miniorange_oauth_client_appval',$appValue);
  variable_set('miniorange_auth_client_callback_uri',$miniorange_auth_client_callback_uri);
  variable_set('miniorange_oauth_client_enforce_https_checkbox',$baseUrlCheckbox);

  drupal_set_message(t('Signin Settings successfully saved'));
}

/**
 * Send support query.
 */
function send_support_query(&$form, $form_state)
{
    $email = trim($form['miniorange_oauth_email_address_support']['#value']);
    $phone = $form['miniorange_oauth_phone_number_support']['#value'];
    $query = trim($form['miniorange_oauth_support_query_support']['#value']);
    Utilities::send_query($email, $phone, $query, null);
}
function rfd(&$form, $form_state) {

    global $base_url;
    drupal_goto($base_url.'/admin/config/people/oauth_login_oauth2/request_for_demo');
}
