<?php

namespace Drupal\oci_osfs\Service;

use Drupal\Core\Config\ConfigFactoryInterface;

/**
 * Creates official OCI Object Storage clients.
 *
 * NOTE:
 * The oracle/oci-php-sdk is evolving. This factory is structured to keep
 * all SDK construction logic in one place. Align the pseudocode with the
 * exact classes/namespaces in your installed SDK version.
 */
class OciObjectStorageFactory {

  public function __construct(
    protected ConfigFactoryInterface $configFactory,
    protected OciAuthFactory $authFactory
  ) {}

  /**
   * Build and return an Object Storage client instance.
   */
  public function createClient(): object {
    $c = $this->configFactory->get('oci_osfs.settings');
    $auth = $this->authFactory->createAuth();

    $region = (string) $c->get('region');
    if ($region === '') {
      throw new \RuntimeException('Region not configured.');
    }

    // PSEUDOCODE:
    //
    // use Oracle\Oci\ObjectStorage\ObjectStorageClient;
    // use Oracle\Oci\Auth\ApiKeyAuth;
    // use Oracle\Oci\Auth\InstancePrincipalsAuth;
    //
    // $provider = $auth['type'] === 'instance_principals'
    //   ? new InstancePrincipalsAuth()
    //   : new ApiKeyAuth(
    //       $auth['tenancy_ocid'],
    //       $auth['user_ocid'],
    //       $auth['fingerprint'],
    //       $auth['private_key_path'],
    //       $auth['passphrase']
    //     );
    //
    // return new ObjectStorageClient($provider, $region);

    throw new \RuntimeException('Implement ObjectStorageClient construction per your installed oracle/oci-php-sdk version.');
  }

}
