<?php

namespace Drupal\oci_osfs\Routing;

use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Drupal\Core\StreamWrapper\StreamWrapperManagerInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\Routing\Route;

/**
 * Defines routes for OCI image styles.
 */
class OciImageStyleRoutes implements ContainerInjectionInterface {

  /**
   * The stream wrapper manager service.
   */
  protected StreamWrapperManagerInterface $streamWrapperManager;

  /**
   * Constructs a new OciImageStyleRoutes object.
   */
  public function __construct(StreamWrapperManagerInterface $stream_wrapper_manager) {
    $this->streamWrapperManager = $stream_wrapper_manager;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('stream_wrapper_manager')
    );
  }

  /**
   * Returns an array of route objects.
   *
   * @return \Symfony\Component\Routing\Route[]
   *   An array of route objects.
   */
  public function routes() {
    $routes = [];

    // Create route for OCI image style derivatives
    // This matches /system/files/styles/{image_style}/oci/{path}
    $routes['oci_osfs.image_style'] = new Route(
      '/system/files/styles/{image_style}/oci',
      [
        '_controller' => 'Drupal\image\Controller\ImageStyleDownloadController::deliver',
        'scheme' => 'oci',
        'required_derivative_scheme' => 'oci',
      ],
      [
        '_access' => 'TRUE',
      ],
      [
        'no_cache' => TRUE,
      ]
    );

    return $routes;
  }

}
