<?php

namespace Drupal\Tests\oci_osfs\Kernel;

use Drupal\KernelTests\KernelTestBase;

/**
 * Basic config smoke test.
 *
 * Full stream tests require either:
 * - a test double for the PHP stream bridge, or
 * - a dedicated OCI test environment.
 */
class OciStreamWrapperKernelTest extends KernelTestBase {

  protected static $modules = [
    'system',
    'user',
    'file',
    'oci_osfs',
  ];

  protected function setUp(): void {
    parent::setUp();
    $this->installEntitySchema('file');
    $this->installConfig(['oci_osfs']);

    $this->config('oci_osfs.settings')
      ->set('region', 'me-jeddah-1')
      ->set('namespace', 'dummy')
      ->set('bucket', 'dummy')
      ->save();
  }

  public function testConfigLoads(): void {
    $this->assertEquals('me-jeddah-1', $this->config('oci_osfs.settings')->get('region'));
  }

}
