window.addEventListener("load", (event) => {
  const addEventIcon = document.querySelector(
    ".app-menu__item.menu-item--expanded"
  );
  if (addEventIcon !== null) {
    const addEventUl = addEventIcon.querySelector("ul");
    addEventIcon.addEventListener("click", function () {
      addEventUl.classList.toggle("active");
    });
  }

  // Dark mode
  const body = document.querySelector("body");
  let darkModeStorage = window.localStorage.getItem("darkMode");

  //the toggle
  const accountMenu = document.querySelector(
    "#block-octavia-camouflage-account-menu nav ul"
  );
  const darkModeToggle = document.createElement("li");
  darkModeToggle.classList.add("darkmode-toggle");
  accountMenu.append(darkModeToggle);

  if (typeof darkModeStorage === "undefined") {
    // if storage is not set, match the browser preference
    if (
      window.matchMedia &&
      window.matchMedia("(prefers-color-scheme: dark)").matches
    ) {
      if (!body.classList.contains("dark")) {
        body.classList.add("dark");
      }
    }
  } else {
    // since it's defined, let's set it to what's in storage
    if (darkModeStorage === "true") {
      if (!body.classList.contains("dark")) {
        body.classList.add("dark");
      }
    } else if (body.classList.contains("dark")) {
      body.classList.remove("dark");
    }
    darkModeToggle.addEventListener("click", function (e) {
      e.preventDefault();
      if (body.classList.contains("dark")) {
        body.classList.remove("dark");
        window.localStorage.setItem("darkMode", false);
      } else {
        body.classList.add("dark");
        window.localStorage.setItem("darkMode", true);
      }
    });
  }

  
  // Accordions
  
  // Search form accordion
  const accordionForm = 
    document.getElementById("views-exposed-form-event-events-listing-list") ||
    document.getElementById("views-exposed-form-event-events-listing-card")
  if (accordionForm) {
      const formToggle = document.querySelector(".form-accordion-toggle")
      formToggle.addEventListener("click", function (e) {
        accordionForm.classList.toggle("collapsed");
        formToggle.classList.toggle("closed");
      });
  }

  // Category list accordion
  const cats = document.getElementById("event-category-search-categories-with-children");
  if (cats) {
      const catToggle = document.createElement("div");
      catToggle.classList.add("category-toggle","is-flex", "is-justify-content-end");
      catToggle.addEventListener("click", function (e) {
          cats.classList.toggle("collapsed");
          catToggle.classList.toggle("closed");
        });
        cats.before(catToggle);
  }
});
