<?php

namespace Drupal\oembed_configuration\Plugin\OEmbedConfigurationProvider;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\oembed_configuration\Attribute\OEmbedConfigurationProvider;
use Drupal\oembed_configuration\OEmbedConfigurationProviderPluginBase;

/**
 * Plugin implementation of the oembed_configuration_provider for Vimeo.
 *
 * @see https://developer.x.com/en/docs/x-for-websites/oembed-api
 * @see https://developer.x.com/en/docs/x-for-websites/embedded-tweets/overview
 */
#[OEmbedConfigurationProvider(
    id: 'X',
    label: new TranslatableMarkup('X'),
    description: new TranslatableMarkup('X OEmbed configuration.')
)]
class X extends OEmbedConfigurationProviderPluginBase {

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state): array {
    $form = parent::buildConfigurationForm($form, $form_state);
    $config_data = $this->config->get($this->pluginId);

    $form['query'] = [
      '#type' => 'details',
      '#title' => $this->t('Query parameters'),
    ];
    $form['query']['dnt'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Do not track'),
      '#description' => $this->t('When set to true, the timeline and its embedded page on your site are not used for purposes that include personalized suggestions and personalized ads.'),
      '#default_value' => $config_data['query']['dnt'] ?? $this->defaultConfiguration()['query']['dnt'],
    ];
    $form['query']['hide_thread'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Hide parent posts'),
      '#default_value' => $config_data['query']['hide_thread'] ?? $this->defaultConfiguration()['query']['hide_thread'],
    ];
    $form['query']['omit_script'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Omit Script'),
      '#description' => $this->t('Do not include a script element in the response.'),
      '#default_value' => $config_data['query']['omit_script'] ?? $this->defaultConfiguration()['query']['omit_script'],
    ];
    $form['query']['theme'] = [
      '#type' => 'select',
      '#title' => $this->t('Theme type'),
      '#options' => [
        '' => $this->t('Light'),
        'dark' => $this->t('Dark'),
      ],
      '#description' => $this->t('When set to dark, the timeline is displayed with light text over a dark background.'),
      '#default_value' => $config_data['query']['theme'] ?? $this->defaultConfiguration()['query']['theme'],
    ];
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration(): array {
    return parent::defaultConfiguration() + [
      'query' => [
        'dnt' => TRUE,
        'hide_thread' => FALSE,
        'omit_script' => FALSE,
        'theme' => '',
      ],
    ];
  }

}
