<?php

namespace Drupal\oembed_configuration\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Form\SubformState;
use Drupal\oembed_configuration\OEmbedConfigurationProviderPluginManager;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides oEmbed configuration form.
 */
class SettingsForm extends ConfigFormBase {

  /**
   * OEmbed configuration provider manager.
   *
   * @var \Drupal\oembed_configuration\OEmbedConfigurationProviderPluginManager
   */
  protected OEmbedConfigurationProviderPluginManager $providerManager;

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'oembed_configuration_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['oembed_configuration.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    $instance = parent::create($container);
    $instance->providerManager = $container->get('plugin.manager.oembed_configuration_provider');
    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    foreach ($this->providerManager->getDefinitions() as $definition) {
      $subform_id = $definition['id'];
      $instance = $this->providerManager->createInstance($subform_id);
      $form[$subform_id]['settings']['wrapper'] = [
        '#type' => 'details',
        '#title' => $definition['label'],
        '#open' => FALSE,
      ];
      $form[$subform_id]['settings']['wrapper']['subform'] = [];
      $subform_state = SubformState::createForSubform($form[$subform_id]['settings']['wrapper']['subform'], $form, $form_state);
      $subform = $instance->buildConfigurationForm($form[$subform_id]['settings']['wrapper']['subform'], $subform_state);
      if ($subform) {
        $form_state->set($subform_id, $instance);
        $form[$subform_id]['settings']['wrapper']['subform'] = $subform;
        $form[$subform_id]['settings']['wrapper']['subform']['#parents'] = [$subform_id, 'settings', 'wrapper'];
      }
    }
    $form['#tree'] = TRUE;

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    foreach ($this->providerManager->getDefinitions() as $definition) {
      $subform_id = $definition['id'];
      $instance = $form_state->get($subform_id);
      if ($instance) {
        $subform_state = SubformState::createForSubform($form[$subform_id]['settings']['wrapper']['subform'], $form, $form_state);
        $instance->submitConfigurationForm($form[$subform_id]['settings']['wrapper']['subform'], $subform_state);
      }
    }

    parent::submitForm($form, $form_state);
  }

}
