<?php

namespace Drupal\oembed_configuration;

use Drupal\Component\Plugin\DependentPluginInterface;
use Drupal\Component\Plugin\PluginInspectionInterface;
use Drupal\Core\Cache\CacheableDependencyInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\Plugin\PluginFormInterface;

/**
 * Interface for oembed_configuration_provider plugins.
 */
interface OEmbedConfigurationProviderInterface extends PluginFormInterface, PluginInspectionInterface, DependentPluginInterface, CacheableDependencyInterface, ContainerFactoryPluginInterface {

  const string OEMBED_CONFIGURATION_SETTINGS = 'oembed_configuration.settings';

  /**
   * Modifies the provided parsed URL by applying query parameters.
   *
   * @param array $parsed_url
   *   The parsed URL array that will be updated.
   */
  public function applyQueryParams(array &$parsed_url): void;

  /**
   * Modifies the provided parsed URL.
   *
   * @param array $parsed_url
   *   The parsed URL passed by reference.
   */
  public function overrideUrl(array &$parsed_url): void;

  /**
   * Overrides additional values such as the URL.
   *
   * @param array $data
   *   The data array passed by reference.
   */
  public function overrideValues(array &$data): void;

}
