<?php

namespace Drupal\oembed_configuration;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\oembed_configuration\Attribute\OEmbedConfigurationProvider;

/**
 * OEmbedConfiguration plugin manager.
 */
class OEmbedConfigurationProviderPluginManager extends DefaultPluginManager {

  /**
   * The plugin's subdirectory.
   */
  const string PLUGIN_SUBDIR = 'Plugin/OEmbedConfigurationProvider';

  /**
   * The name of the annotation that contains the plugin definition.
   */
  const string PLUGIN_ANNOTATION_NAME = 'Drupal\oembed_configuration\Annotation\OEmbedConfigurationProvider';

  /**
   * Name of the alter hook for the plugins.
   */
  const string ALTER_HOOK = 'oembed_configuration_provider_info';

  /**
   * Name of the cache key for plugin data.
   */
  const string CACHE_KEY = 'oembed_configuration_plugins';

  /**
   * Constructs OEmbedConfigurationProviderPluginManager object.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct(
          self::PLUGIN_SUBDIR,
          $namespaces,
          $module_handler,
          OEmbedConfigurationProviderInterface::class,
          OEmbedConfigurationProvider::class,
          self::PLUGIN_ANNOTATION_NAME
      );

    $this->alterInfo(self::ALTER_HOOK);
    $this->setCacheBackend($cache_backend, self::CACHE_KEY);

  }

  /**
   * Display definitions as an option of select elements.
   *
   * @return array
   *   Array of options.
   */
  public function definitionsOptions() {
    $options = [];
    foreach ($this->getDefinitions() as $definition) {
      $options[$definition['id']] = $definition['label'];
    }
    return $options;
  }

}
