<?php

namespace Drupal\oembed_field\Plugin\Validation\Constraint;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Validation\Attribute\Constraint;
use Symfony\Component\Validator\Constraint as SymfonyConstraint;

/**
 * Checks if oEmbed URL is from an allowed provider bucket.
 */
#[Constraint(
  id: 'OembedFieldUrl',
  label: new TranslatableMarkup('oEmbed field url constraint', [], ['context' => 'Validation'])
)]
class OembedFieldUrlConstraint extends SymfonyConstraint {

  /**
   * The allowed bucket IDs.
   *
   * @var array
   */
  public $allowed_buckets = [];

  /**
   * Violation message.
   *
   * @var string
   */
  public $message = 'The URL "@url" is not from an allowed oembed provider.';

}
