# oEmbed Field

The oEmbed Field module provides an alternative to using Media entities for embedding oEmbed content.

Unlike Drupal's core Media module, which creates separate Media entities for each embed, this module stores the oEmbed URL directly in the field and simply renders the oEmbed content on the entity the field is on. This reduces database complexity for sites with thousands of embedded videos or other oEmbed content.

I originally created this module because my editors needed a simple way to paste a YouTube or Vimeo URL directly into a node (or any other entity). They didn't need a media library, and when they edited a node to change the URL, we didn't want to deal with orphaned Media entities left behind. This approach makes editing straightforward for this use case. Since this module leverages Media's oEmbed functionality, any enabled oEmbed provider will work.

If you use the thumbnail formatter, thumbnails will be downloaded only on demand the first time and stored in Drupal's managed files system.

Although this module does not create Media entities, the **Media** module is required because we leverage its oEmbed services. The optional **[oEmbed Providers](https://www.drupal.org/project/oembed_providers)** module allows you to restrict which oEmbed providers can be embedded, using provider buckets.

## Features

- **Simple workflow**: Editors paste a URL, no Media entity creation required.
- **Direct field storage**: Stores the oEmbed URL directly in the field.
- **Smart thumbnail management**: Downloads thumbnails on demand and stores them in Drupal's managed files system with deduplication.
- **Two display formatters**: Choose between full embedded content or thumbnail-only display with linking options.
- **Provider filtering**: Optional integration with the oEmbed Providers module allows restricting which platforms are allowed per field.

## When to Use This Module

- Embeds are unique to each piece of content and not intended to be reused.
- You want a simple editor workflow without media library steps.
- You have high-volume content where Media entity overhead is unnecessary.
- Embeds do not need custom fields or standalone management.

## When to Use the Media Module Instead

- You need to reuse the same embed across multiple pages.
- You need media library browsing or selection functionality.
- You need custom fields on your embeds.
- You need media-specific permissions or workflows.

## Requirements
- Media module (core) - provides oEmbed services
- File module (core)
- Field module (core)

## Installation

Install as you would normally install a contributed Drupal module. See:
https://www.drupal.org/node/1897420 for further information.

## Configuration

1. **Add a field to your content type**:
  - Navigate to Structure → Content types → Manage fields
  - Add "oEmbed URL" field
  - Note: Cannot be added to Media entities

2. **Configure field settings**:
  - Select allowed provider buckets (requires oEmbed Providers module, optional)
  - Set the thumbnail directory path (supports tokens)

3. **Configure display**:
  - **oEmbed content formatter**: Displays the full embedded content
  - **oEmbed thumbnail formatter**: Displays only the thumbnail

**Editor workflow**: Paste URL → Save → Content displays using the chosen formatter

## Recommended Modules

- **oEmbed Providers** (https://www.drupal.org/project/oembed_providers): Organize providers into buckets and restrict fields to specific provider types
- **Token** (https://www.drupal.org/project/token): Use tokens for thumbnail directory paths

## Similar Projects

**[Video Embed Field](https://www.drupal.org/project/video_embed_field)**: Similar in concept but video-specific and does not 
use Drupal core's oEmbed services. oEmbed Field supports all oEmbed types and integrates with provider bucket filtering.

**Core Media Module**: A full-featured solution with a media library, reusable entities, custom fields, and workflows. Use Media when you need those features; use oEmbed Field for simpler, non-reusable embeds.

## Technical Details

- Centralized thumbnail storage in `oembed_field_thumbnails` database table with hash-based deduplication
- Thumbnails downloaded on-demand during rendering, not on entity save
- Lock mechanism prevents concurrent downloads of the same thumbnail
- Field stores: URL, URL hash, and provider name only
- Leverages Media module's oEmbed services without creating entities

## Maintainers

Current maintainers:
- [loze] - https://www.drupal.org/u/loze
