<?php

declare(strict_types=1);

namespace Drupal\oembed_tweak\Attribute;

use Drupal\Component\Plugin\Attribute\AttributeBase;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Provides an attribute for OEmbed tweaks.
 */
#[\Attribute]
class OEmbedTweak extends AttributeBase {

  /**
   * Constructs an OEmbedTweak attribute.
   *
   * @param string $id
   *   The tweak plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup $label
   *   The label for the tweak.
   * @param string[] $providers
   *   A list of providers the tweak applies to.
   *
   * @noinspection PhpMissingParentConstructorInspection
   */
  public function __construct(
    protected readonly string $id,
    protected readonly TranslatableMarkup $label,
    protected readonly array $providers = [],
  ) {
  }

}
