<?php

declare(strict_types=1);

namespace Drupal\oembed_tweak\OEmbedTweak;

/**
 * Provides an interface for OEmbed tweaks.
 */
interface TweakInterface {

  /**
   * Checks whether this tweak applies to the given resource data.
   *
   * @param array $data
   *   The resource data as returned by the provider.
   * @param string $url
   *   The resource URL.
   *
   * @return bool
   *   TRUE if this tweak applies; FALSE otherwise.
   */
  public function isApplicable(array $data, string $url): bool;

  /**
   * Tweaks the given resource data.
   *
   * @param array $data
   *   The resource data as returned by the provider.
   * @param string $url
   *   The resource URL.
   *
   * @return array
   *   The tweaked resource data.
   */
  public function tweak(array $data, string $url): array;

}
