<?php

declare(strict_types=1);

namespace Drupal\oembed_tweak\OEmbedTweak;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\oembed_tweak\Attribute\OEmbedTweak;

/**
 * Provides a plugin manager for OEmbed tweaks.
 */
class TweakPluginManager extends DefaultPluginManager {

  public function __construct(\Traversable $namespaces, CacheBackendInterface $cacheBackend, ModuleHandlerInterface $moduleHandler) {
    parent::__construct(
      'Plugin/OEmbedTweak',
      $namespaces,
      $moduleHandler,
      TweakInterface::class,
      OEmbedTweak::class,
    );
    $this->alterInfo('oembed_tweak_info');
    $this->setCacheBackend($cacheBackend, 'oembed_tweak_plugins');
  }

}
