<?php

declare(strict_types=1);

namespace Drupal\oembed_tweak\Plugin\OEmbedTweak;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\oembed_tweak\Attribute\OEmbedTweak;

// cspell:ignore giphy

/**
 * Provides a tweak to add a missing version key.
 */
#[OEmbedTweak(
  'add_version',
  new TranslatableMarkup('Add missing version'),
  [
    'GIPHY',
  ]
)]
class AddVersion extends OEmbedTweakBase {

  /**
   * {@inheritdoc}
   */
  public function tweak($data, string $url): array {
    return $data + [
      'version' => '1.0',
    ];
  }

}
