<?php

declare(strict_types=1);

namespace Drupal\oembed_tweak\Plugin\OEmbedTweak;

use Drupal\Core\Plugin\PluginBase;
use Drupal\oembed_tweak\OEmbedTweak\TweakInterface;

/**
 * Provides a base implementation for OEmbed tweaks.
 */
abstract class OEmbedTweakBase extends PluginBase implements TweakInterface {

  /**
   * {@inheritdoc}
   */
  public function isApplicable($data, string $url): bool {
    assert(is_array($this->pluginDefinition['providers']));
    if (isset($data['provider_name']) && is_string($data['provider_name'])) {
      return in_array($data['provider_name'], $this->pluginDefinition['providers'], TRUE);
    }
    return FALSE;
  }

}
