<?php

namespace Drupal\Tests\og_migrate\Kernel\Migrate;

use Drupal\Tests\migrate_drupal\Kernel\d6\MigrateDrupal6TestBase;
use Drupal\og\Og;

/**
 * Tests the creation of og_audience fields.
 *
 * @group og_migrate
 *
 * @internal
 */
class OgAudienceD6MigrateTest extends MigrateDrupal6TestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'text',
    'menu_ui',
    'node',
    'og',
    'og_ui',
    'og_migrate',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->installEntitySchema('node');
    $this->installEntitySchema('node_type');
    $this->installEntitySchema('og_membership_type');
    $this->installEntitySchema('og_membership');
    $this->installEntitySchema('og_role');
    $this->installConfig(['node', 'og']);
    $this->loadFixture(__DIR__ . '/../../../fixtures/drupal6.php');
    $this->migrateContentTypes();
    $this->executeMigrations([
      'd6_og_group_type',
      'd6_og_audience',
    ]);
  }

  /**
   * Asserts that fields are created on content types.
   */
  public function testOgAudienceFields() {
    $this->assertTrue(Og::isGroupContent('node', 'story'), 'Created node.story.og_audience');
    $this->assertTrue(Og::isGroupContent('node', 'test_planet'), 'Created node.test_planet.og_audience');
    $this->assertFalse(Og::isGroupContent('node', 'page'), 'Did not create node.page.og_audience');
  }

}
