<?php

namespace Drupal\Tests\og_migrate\Kernel\Migrate;

use Drupal\Core\Entity\Entity\EntityFormDisplay;
use Drupal\Core\Entity\Entity\EntityViewDisplay;
use Drupal\Tests\migrate_drupal\Kernel\d7\MigrateDrupal7TestBase;
use Drupal\og\Entity\OgMembershipType;

/**
 * Tests organic groups membership type migration.
 *
 * @group og_migrate
 *
 * @internal
 */
class OgMembershipTypeD7MigrateTest extends MigrateDrupal7TestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['text', 'system', 'og', 'og_migrate'];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->installConfig(['og']);
    $this->installEntitySchema('og_membership_type');
    $this->loadFixture(__DIR__ . '/../../../fixtures/drupal7.php');
    $this->executeMigrations(['d7_og_membership_type']);
  }

  /**
   * Asserts that the membership types are migrated.
   *
   * This includes the entities, view and form displays.
   */
  public function testOgMembershipType() {
    $type = OgMembershipType::load('default');

    $this->assertInstanceOf('\Drupal\og\Entity\OgMembershipType', $type);
    $this->assertEquals('Custom default description.', $type->label());

    $types = OgMembershipType::loadMultiple();

    $this->assertCount(1, $types, 'Migrated default migration into Drupal 8 default.');

    $form_display = EntityFormDisplay::load('og_membership.default.default');

    $this->assertNotNull($form_display);

    $view_display = EntityViewDisplay::load('og_membership.default.default');

    $this->assertNotNull($view_display);
  }

}
