<?php

namespace Drupal\ohdear_integration;

/**
 * Trait for validating date formats.
 */
trait DateFormatValidationTrait {

  /**
   * Validate that a date string is in the correct format (Y-m-d H:i:s).
   *
   * @param string $dateString
   *   The date string to validate.
   *
   * @return bool
   *   True if the date string is valid, false otherwise.
   */
  public function isValidDateFormat(string $dateString): bool {
    $dateTime = \DateTime::createFromFormat('Y-m-d H:i:s', $dateString);
    return $dateTime && $dateTime->format('Y-m-d H:i:s') === $dateString;
  }

}
