Allows connection via FranceConnect V2 (No Franceconnect+), at managing authentication and compliance with the qualification rules required by FranceConnect.

### Features

This module allows you to connect to a Drupal site using **[Franceconnect V2](https://docs.partenaires.franceconnect.gouv.fr/fs/migration/fs-migration-diff-v1-v2/)**, once configured. Version 1 of Franceconnect will no longer be available in September 2025.

It is based on the `openid_connect` module and extends it to meet FranceConnect's specific requirements.

*   Automatically deactivates user fields covered by the `identite_pivot` scope, in accordance with FranceConnect qualification rules.
*   Provides a block that can be placed by the administrator to display a FranceConnect connection
*   Manages mandatory cinematics
*   Displays explicit error messages in the event of problems reported by FranceConnect during cinematics.

**Note :** this module does not manage account reconciliation.

### Pre-installation requirements

Before installing and configuring this module, you need to :

*   Have an integrated environment.
*   Have obtained [FranceConnect accreditation](https://docs.partenaires.franceconnect.gouv.fr/fs/devenir-fs/projet-datapass/) **eidas1 only**. The module does not manage eidas2 or eidas3.
*   Request access to the [FranceConnect Sandbox](https://docs.partenaires.franceconnect.gouv.fr/fs/devenir-fs/projet-bac-a-sable/) to obtain a **Client ID** and **Secret Client** for your integration environment.

    In this request, for the connection redirection url you must enter the following URL: `https://url_of_your_service_env_integration/openid-connect/franceconnect`.

    For the disconnection redirection url, you must enter the following URL: `https://url_de_votre_service_env_integration/franceconnect/logout-callback`

*   Have a domain name that is exposed to the Internet, or at least accessible from the IP addresses provided by FranceConnect when requesting access to the sandbox.

### Post-installation

Once the module has been installed, you need to configure it:

#### Defining scopes and claims

Go to the claims configuration page: `/admin/config/franceconnect/claims`. This form shows you the claims available from FranceConnect. For each claim you are interested in, you must select the associated scope, in accordance with your FranceConnect authorisation.

#### Configuring the OpenID Connect FranceConnect client

Go to `/admin/config/services/openid-connect`. Tick the FranceConnect provider. Fill in the Client ID, the Client Secret and the [sandbox URLs](https://docs.partenaires.franceconnect.gouv.fr/fs/fs-integration/env-sandbox-fc/) supplied by FranceConnect.
In the _User Claims Mapping_ section, associate the previously configured claims configured to the user fields on your site.

#### Placing the FranceConnect block

Go to the block presentation page. Add the FranceConnect block to the /user/login and /user/register pages. ️To comply with FranceConnect display requirements, the block must be placed before the login and registration forms. If your URLs have been customised, adapt the configuration accordingly in Configuration → Pages.

#### Going in production

At this stage, your module is configured: the FranceConnect button is visible on the appropriate pages, and the user information will be mapped according to the chosen claims.

After your tests, you will need to submit a [qualification request to FranceConnect](https://www.demarches-simplifiees.fr/commencer/demande-qualification-fs) to validate compliance with the requirements.

Once the module has been qualified, you must request access to the franceconnect [production environment](https://docs.partenaires.franceconnect.gouv.fr/fs/devenir-fs/env-production-fc/) and install this module on your own production environment and configure it by adapting the client identifier, secret client and production URLs.

### Dependencies

This module requires :

*   The [`openid_connect`](https://www.drupal.org/project/openid_connect) version 1.4 module.
*   The [`firebase/php-jwt`](https://github.com/firebase/php-jwt) library

These dependencies are automatically installed when this module is installed.

### Similar projects

There are currently two franceconnect modules : [franceconnect](https://www.drupal.org/project/franceconnect) and [oidc\_franceconnect](https://www.drupal.org/project/oidc_franceconnect) that meet the technical requirements for franceconnect V1.

This proposed module differs in that it focuses on the requirements of [franceconnect V2](https://docs.partenaires.franceconnect.gouv.fr/fs/migration/fs-migration-diff-v1-v2/).

### Credits
This module is inspired by the following module https://www.drupal.org/project/franceconnect created by https://www.drupal.org/u/tostinni
