<?php

namespace Drupal\franceconnect\EventSubscriber;

use Drupal\Core\Messenger\MessengerTrait;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpKernel\Event\ResponseEvent;
use Symfony\Component\HttpKernel\KernelEvents;

/**
 * Subscriber for handling FranceConnect related events.
 */
class FranceConnectSubscriber implements EventSubscriberInterface {

  use MessengerTrait;

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents() {
    return [
      KernelEvents::RESPONSE => ['onResponse', 0],
    ];
  }

  /**
   * Changes the default error message from OpenIdConnect.
   */
  public function onResponse(ResponseEvent $event) {
    $request = $event->getRequest();
    $route_match = \Drupal::routeMatch();
    $route_name = $route_match->getRouteName();

    if ($route_name === 'openid_connect.redirect_controller_redirect') {

      $error = $request->query->get('error');
      if ($error) {
        // Delete openidconnect default message error
        // "Could not authenticate with @provider."
        $messages = $this->messenger()->deleteByType('error');
        switch ($error) {
          case 'invalid_scope':
            $this->messenger()->addError(t("La connexion n'a pas pu aboutir en raison d\'un problème technique. Veuillez choisir un autre mode de connexion. (invalid_scope)"));
            break;

          case 'invalid_request':
            $this->messenger()->addError(t("La connexion n'a pas pu aboutir en raison d\'un problème technique. Veuillez choisir un autre mode de connexion. (invalid_request)"));
            break;

          case 'access_denied':
            $this->messenger()->addError(t("Une erreur technique est survenue. Veuillez réessayer ou choisir un autre mode de connexion. (access_denied)"));
            break;

          case 'server_error':
            $this->messenger()->addError(t('Une erreur technique est survenue. Veuillez réessayer ou choisir un autre mode de connexion. (server_error)'));
            break;

          case 'temporarily_unavailable':
            $this->messenger()->addError(t('Une erreur technique est survenue. Veuillez réessayer ou choisir un autre mode de connexion. (temporarily_unavailable)'));
            break;

          default:
            $this->messenger()->addError(t('Une erreur est survenue, veuillez réessayer ou utilisez un autre mode de connexion.'));
            break;
        }
      }
    }
  }

}
