<?php

namespace Drupal\oidc_mcpf;

/**
 * Provides the possible audiences.
 */
class Audience {

  public const CITIZEN = 'BUR';
  public const ORGANIZATION = 'EA';
  public const ASSOCIATION = 'VER';
  public const EDUCATION = 'OV';
  public const GOV_FLEMISH = 'GID';
  public const GOV_LOCAL = 'LB';

  /**
   * Get the audiences as options array.
   *
   * @return \Drupal\Core\StringTranslation\TranslatableMarkup[]
   *   The options array.
   */
  public static function getOptions(): array {
    return [
      self::CITIZEN => t('Citizens'),
      self::ORGANIZATION => t('Companies and associations'),
      self::ASSOCIATION => t('Factual associations'),
      self::EDUCATION => t('Educational and training institutions'),
      self::GOV_FLEMISH => t('Flemish governments'),
      self::GOV_LOCAL => t('Local governments'),
    ];
  }

}
