<?php

namespace Drupal\oidc_mcpf;

use Drupal\Core\Access\AccessResultInterface;

/**
 * Provides an interface for the toolbar service.
 */
interface ToolbarInterface {

  /**
   * Alter the library definition of the toolbar.
   *
   * @param array $library
   *   The toolbar library definition.
   */
  public function alterLibrary(array &$library): void;

  /**
   * Check if the toolbar can be attached.
   *
   * @return \Drupal\Core\Access\AccessResultInterface
   *   The access result:
   *   - Neutral: the toolbar may be attached.
   *   - Allowed: the toolbar must be attached.
   *   - Forbidden: the toobar shouldn't be attached.
   *   It may contain cacheability metadata.
   */
  public function access(): AccessResultInterface;

  /**
   * Attach the toolbar.
   *
   * @param array $attachments
   *   The page attachments.
   */
  public function attach(array &$attachments): void;

}
