/**
 * @file
 * The toolbar library.
 */

(function (Drupal, once) {

  'use strict';

  Drupal.behaviors.oidcMcpfToolbar = {
    attach: (context, settings) => {
      settings = settings.oidcMcpf.toolbar;

      once('oidc-mcpf-toolbar', 'body', context).forEach((body) => {
        const toolbar = window.globalHeaderClient;

        // Configure the global header.
        toolbar.accessMenu.setProfile(settings.accessMenu.profile);
        toolbar.accessMenu.setVisibility(settings.accessMenu.visibility);

        if (settings.languageSwitcher !== null && toolbar.languageSwitcher !== undefined) {
          toolbar.languageSwitcher.configure(settings.languageSwitcher);
        }

        // Add a class to the body.
        body.classList.add('oidc-mcpf-toolbar');
      });
    }
  }

})(Drupal, once);
