<?php

namespace Drupal\oidc_mcpf_user_purge;

/**
 * Provides an interface for the user purger service.
 */
interface UserPurgerInterface {

  /**
   * Purge inactive users.
   *
   * @param int $timeout
   *   How long the user must be minimaly inactive (in seconds).
   * @param string[] $excluded_roles
   *   The excluded role IDs.
   * @param int $limit
   *   Maximum number of users to be purged.
   */
  public function purgeInactive(int $timeout, array $excluded_roles = [], int $limit = 50): void;

}
