<?php

namespace Drupal\oidc_mcpf;

/**
 * Provides the role map types.
 */
class RoleMapType {

  const AUDIENCE = 'audience';
  const IDM = 'idm';

  /**
   * Get the types as options array.
   *
   * @return \Drupal\Core\StringTranslation\TranslatableMarkup[]
   *   The types array.
   */
  public static function getOptions(): array {
    return [
      self::AUDIENCE => t('Audience'),
      self::IDM => t('IDM'),
    ];
  }

}
