<?php

namespace Drupal\okta_user_sync\Form;

use Drupal\Component\Serialization\Json;
use Drupal\Core\Config\Config;
use Drupal\Core\Config\ImmutableConfig;
use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;
use Drupal\user\Entity\User;

/**
 * Class for Mapping attributes.
 */
class MoMappingTab extends FormBase {

  /**
   * ImmutableConfig property.
   *
   * @var Drupal\Core\Config\ImmutableConfig
   */
  private ImmutableConfig $config;

  /**
   * Config property.
   *
   * @var Drupal\Core\Config\Config
   */
  private Config $configfactory;

  /**
   * Messenger property.
   *
   * @var object
   */
  protected $messenger;

  /**
   * Constructs a new MoMappingTab object.
   */
  public function __construct() {
    $this->config = \Drupal::config('okta_user_sync.settings');
    $this->configfactory = \Drupal::configFactory()->getEditable('okta_user_sync.settings');
    $this->messenger = \Drupal::messenger();
  }

  /**
   * FormID of the form.
   *
   * @return string
   *   Returns formID of the form.
   */
  public function getFormId() {
    return 'MoMappingTab';
  }

  /**
   * Build Mapping form.
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    \Drupal::configFactory()->getEditable('okta_user_sync.settings')->set('okta_user_sync_status1', 'mo_mapping_tab')->save();

    $form['mo_okta_sync_add_css'] = [
      '#attached' => [
        'library' => [
          'okta_user_sync/okta_user_sync.admin',
          'okta_user_sync/okta_user_sync.okta_test',
          'core/drupal.dialog.ajax',
        ],
      ],
    ];
    $form['mo_summary_okta_header_style'] = [
      '#markup' => t('<div class="mo_okta_header_container_summary">'),
    ];

    if (($this->config->get('mo_okta_attr_list_from_server')) != '') {
      $okta_test_data = Json::decode($this->config->get('mo_okta_attr_list_from_server'));
    }
    if (isset($okta_test_data['id']) || isset($okta_test_data['errorCode'])) {

      $form['mapping_tab_attribute_button'] = [
        '#type' => 'link',
        '#title' => t('Attributes Received from Okta'),
        '#url' => Url::fromRoute('okta_user_sync.attributeListOfOkta'),
        '#attributes' => ['style' => ['float: right'], 'class' => ['button', 'button--primary', 'use-ajax', 'js-form-submit', 'form-submit'], 'data-dialog-type' => 'modal', 'data-dialog-options' => json_encode(['width' => '65%'])],
        '#limit_validation_errors' => [],
      ];
    }
    $mo_premium_tag = '<a href = "okta_upgrade_plans" >[PREMIUM]</a>';

    $form['mo_okta_attribute_mapping_details']['okta_attribute_mapping'] = [
      '#type' => 'fieldset',
      '#title' => t('Basic Attribute Mapping ') . '<hr>',
      '#prefix' => '<br><br><br>',
    ];
    $custom_fields = [];
    $usr = User::load(\Drupal::currentUser()->id());
    $usrVal = $usr->toArray();
    foreach ($usrVal as $key => $value) {
      $custom_fields[$key] = $key;
    }
    $username_attr = $this->configfactory->get('okta_user_sync_basic_username_mapping');
    $mail_attr = $this->configfactory->get('okta_user_sync_basic_mail_mapping');

    $username_attr = $username_attr ?? 'mail';
    $mail_attr = $mail_attr ?? 'mail';

    $form['mo_okta_attribute_mapping_details']['okta_attribute_mapping']['okta_username_attribute'] = [
      '#type' => 'select',
      '#title' => t('Username Attribute'),
      '#attributes' => ['style' => 'width:30rem', 'placeholder' => 'Enter Username attribute'],
      '#default_value' => $custom_fields[$username_attr],
      '#disabled' => TRUE,
      '#options' => $custom_fields,
    ];

    $form['mo_okta_attribute_mapping_details']['okta_attribute_mapping']['okta_email_attribute'] = [
      '#type' => 'select',
      '#title' => t('Email Attribute'),
      '#default_value' => $custom_fields[$mail_attr],
      '#options' => $custom_fields,
      '#disabled' => TRUE,
      '#attributes' => ['style' => 'width:30rem', 'placeholder' => 'Enter Email attribute'],
    ];

    $form['mo_okta_attribute_mapping_details']['mo_okta_automatic_prov_custom_attribute_mapping'] = [
      '#type' => 'fieldset',
      '#title' => t('Custom Attribute Mapping') . ' ' . $mo_premium_tag . '<hr>',
    ];

    $form['mo_okta_attribute_mapping_details']['mo_okta_automatic_prov_custom_attribute_mapping']['attribute_mapping_info'] = [
      '#markup' => '<div class="mo_okta_highlight_background">This feature allows you to map the user attributes from your Drupal to Okta as well as from Okta to Drupal.</div>',
    ];
    $custom_attr_mapping_header = [
      ['data' => t('Drupal Field Machine Name'), 'width' => '35%' ],
      ['data' => t('Okta Attribute Name'), 'width' => '35%'],
      ['data' => t('Operation'), 'width' => '10%'],
    ];

    $form['mo_okta_attribute_mapping_details']['mo_okta_automatic_prov_custom_attribute_mapping']['attribute_mapping_table'] = [
      '#type' => 'table',
      '#header' => $custom_attr_mapping_header,
      '#attributes' => ['class' => ['remove_bottom_border']],
    ];

    $form['mo_okta_attribute_mapping_details']['mo_okta_automatic_prov_custom_attribute_mapping']['attribute_mapping_table']['first_row'] = self::getProfileMappingRow('custom_mapping',$custom_fields);
    $form['mo_okta_attribute_mapping_details']['mo_okta_automatic_prov_custom_attribute_mapping']['attribute_mapping_add_more'] = self::generateAddButton();

    $form['profile_mapping'] = [
      '#type' => 'fieldset',
      '#title' => t('Profile Mapping') . ' ' . $mo_premium_tag . '<hr>',
    ];

    $headers = [
      ['data' => t('Drupal Profile Name'), 'width' => '30%'],
      ['data' => t('Drupal Field Machine Name'), 'width' => '30%'],
      ['data' => t('Okta Attribute Name'), 'width' => '30%'],
      ['data' => t('Operation'), 'width' => '8%'],
    ];

    $form['profile_mapping']['profile_mapping_table'] = [
      '#type' => 'table',
      '#header' => $headers,
      '#attributes' => ['class' => ['remove_bottom_border']],
    ];

    $form['profile_mapping']['profile_mapping_table']['first_row'] = self::getProfileMappingRow('profile');
    $form['profile_mapping']['profile_mapping_add_more'] = self::generateAddButton();

    $form['okta_basic_mapping_save_button'] = [
      '#type' => 'submit',
      '#value' => t('Save Configuration '),
      '#button_type' => 'primary',
      '#submit' => ['::saveBasicMappingConfiguration'],
    ];
    return $form;
  }
  /**
   * Generate fields for mapping sections.
   */
  private static function getProfileMappingRow($mapping_type = '', $custom_fields = '') {
    $row = [];

    if ($mapping_type == 'profile') {
      $row['profile_type'] = [
        '#type' => 'textfield',
        '#disabled' => TRUE,
      ];
    }

    if($mapping_type == 'custom_mapping'){
      $row['drupal_field_name'] = [
        '#type' => 'select',
        '#options' =>$custom_fields,
        '#disabled' => true,
      ];
    }else{
      $row['drupal_field_name'] = [
        '#type' => 'textfield',
        '#disabled' => true,
      ];
    }

    $row['okta_attribute_name'] = [
      '#type' => 'textfield',
      '#disabled' => True,
    ];

    $row['delete'] = [
      '#type' => 'button',
      '#value' => t('Delete'),
      '#disabled' => true,
    ];

    return $row;

  }
  /**
   * Generate Add button.
   */
  public static function generateAddButton() {
    $form['button_prefix_mapping'] = [
      '#prefix'  => '<div class="container-inline">',
    ];

    $form['button_add'] = [
      '#type' => 'submit',
      '#value' => t('Add'),
      '#disabled' => True,
    ];

    $form['total_rows'] = [
      '#type' => 'number',
      '#disabled' => true,
      '#default_value' => 1,
      '#min' => 1,
      '#max' => 50,
    ];

    $form['rows_markup'] = [
      '#type' => 'item',
      '#markup' => 'more rows',
      '#prefix' => '&nbsp;&nbsp;',
      '#suffix' => '</div>'
    ];
    return $form;
  }
  /**
   * {@inheritDoc}
   */
  public function saveBasicMappingConfiguration(array &$form, FormStateInterface $form_state) {
    $this->configfactory
      ->set('okta_user_sync_basic_username_mapping', $form_state->getValues()['okta_username_attribute'])
      ->set('okta_user_sync_basic_mail_mapping', $form_state->getValues()['okta_email_attribute'])
      ->save();
  }

  /**
   * {@inheritDoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    // @todo Implement submitForm() method.
  }

}
