class OliveroDarkModeChooser extends HTMLElement {
  storageKey = 'olivero-dark-mode-choice';

  connectedCallback() {
    // Initialize the color scheme.
    const colorScheme = localStorage.getItem(this.storageKey) ?? 'light dark';
    this.setColorScheme(colorScheme);

    // Update the form controls.
    if (colorScheme === 'light' || colorScheme === 'dark') {
      this.querySelector(`input[value=${colorScheme}]`).checked = true;
    }

    // Have the fieldset catch bubbling change events from the radio buttons.
    const element = this;
    this.querySelector('fieldset').addEventListener('change', (event) => {
      element.setColorScheme(event.target.value);
    });
  }

  setColorScheme(colorScheme) {
    // Set a data attribute on the root element.
    document
      .querySelector('html')
      .setAttribute('data-color-scheme', colorScheme);

    // If the form overrides the system color scheme, store it in localStorage.
    if (colorScheme === 'light dark') {
      localStorage.removeItem(this.storageKey);
    } else {
      localStorage.setItem(this.storageKey, colorScheme);
    }
  }
}

customElements.define('olivero-dark-mode-chooser', OliveroDarkModeChooser);
