<?php

/**
 * @file
 * Functions to support Olivero Dark Mode theme settings.
 */

use Drupal\Core\Form\FormStateInterface;

/**
 * Implements hook_form_FORM_ID_alter() for system_theme_settings.
 */
function olivero_dark_mode_form_system_theme_settings_alter(&$form, FormStateInterface $form_state, $form_id = NULL): void {
  // Work-around for a core bug affecting admin themes. See issue #943212.
  if (isset($form_id)) {
    return;
  }

  $form['olivero_dark_mode']['settings'] = [
    '#type' => 'fieldset',
    '#title' => t('Olivero Dark Mode'),
  ];

  $form['olivero_dark_mode']['settings']['chooser_position'] = [
    '#type'          => 'select',
    '#title'         => t('Position of Color Mode chooser'),
    '#empty_option' => t('No chooser'),
    '#empty_value' => '',
    '#options' => [
      'content:last' => t('Content (last item)'),
      'sidebar:first' => t('Sidebar (first item)'),
      'sidebar:last' => t('Sidebar (last item)'),
      'content_below:first' => t('Content Below (first item)'),
      'content_below:last' => t('Content Below (last item)'),
      'footer_top:first' => t('Footer Top (first item)'),
      'footer_top:last' => t('Footer Top (last item)'),
      'footer_bottom:last' => t('Footer Bottom (last item)'),
    ],
    '#description'   => t('Place the Color Mode chooser in the specified region.'),
    '#config_target' => 'olivero_dark_mode.settings:chooser_position',
  ];
}
