<?php

namespace Drupal\olivero_dark_switch\Hook;

use Drupal\Core\Hook\Attribute\Hook;

/**
 * Implementations of Drupal hooks.
 */
class OliveroDarkSwitchHooks {

  /**
   * Implements hook_page_attachments().
   *
   * Set the html data-theme attribute based on user preference
   * if it is not already set in the cookie.
   */
  #[Hook('page_attachments')]
  public static function pageAttachments(array &$attachments) {

    $js = <<<JS
    (function() {
      let element = document.querySelector('html');
      let theme = window.matchMedia('(prefers-color-scheme: dark)').matches ? 'dark' : 'light';
      console.log('Preferred theme: ' + theme);
      document.cookie.split('; ').forEach(function(c){
        if (c.indexOf('olivero_dark_switch.theme=') === 0) {
          theme = c.split('=')[1];
          console.log('Found cookie theme: |' + theme + '|');
        }
      });
      if (theme == 'light' || theme == 'dark') {
        console.log('Setting data-theme attribute to: ' + theme);
        element.setAttribute("data-theme", theme);
      }
    })();
    JS;

    // Now all we need to do is attach the JS to the page.
    $attachments['#attached']['html_head'][] = [
      [
        '#tag' => 'script',
        '#value' => $js,
        '#attributes' => ['type' => 'text/javascript'],
      ],
      'set_html_data_theme_attribute',
    ];
  }

}
