<?php

declare(strict_types=1);

namespace Drupal\olivero_dark_switch\Plugin\Block;

use Drupal\Core\Block\Attribute\Block;
use Drupal\Core\Block\BlockBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Render\Markup;

/**
 * Provides an olivero dark switch block.
 */
#[Block(
  id: 'olivero_dark_switch_block',
  admin_label: new TranslatableMarkup('Olivero Dark Switch'),
  category: new TranslatableMarkup('Custom'),
)]
final class OliveroDarkSwitchBlock extends BlockBase {

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration(): array {
    return [
      'float' => $this->t('Right'),
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function blockForm($form, FormStateInterface $form_state): array {

    $form['float'] = [
      '#type' => 'select',
      '#title' => $this->t('Float'),
      '#description' => $this->t('Impacts the styling of the toggle button.'),
      '#options' => [
        'none' => $this->t('None'),
        'left' => $this->t('Left'),
        'right' => $this->t('Right'),
      ],
      '#default_value' => $this->configuration['float'],
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function blockSubmit($form, FormStateInterface $form_state): void {
    $this->configuration['float'] = $form_state->getValue('float');
  }

  /**
   * {@inheritdoc}
   */
  public function build(): array {
    $build['#attached']['library'][] = 'olivero_dark_switch/toggle';
    $build['#attached']['drupalSettings']['oliveroDarkSwitch']['float'] = $this->configuration['float'];

    $build['content'] = [
      '#type' => 'html_tag',
      '#tag' => 'div',
      '#attributes' => [
        'id' => 'theme-switch',
        'type' => 'button',
        'data-theme-toggle' => 'light',
        'aria-label' => 'Change to the dark theme',
      ],
    ];
    $build['content'][] = [
      '#type' => 'markup',
      '#markup' => Markup::create('<svg id="theme-switch-moon" xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px"><path d="M480-120q-150 0-255-105T120-480q0-150 105-255t255-105q14 0 27.5 1t26.5 3q-41 29-65.5 75.5T444-660q0 90 63 153t153 63q55 0 101-24.5t75-65.5q2 13 3 26.5t1 27.5q0 150-105 255T480-120Z"/></svg>'),
    ];
    $build['content'][] = [
      '#type' => 'markup',
      '#markup' => Markup::create('<svg id="theme-switch-sun" xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px"><path d="M480-280q-83 0-141.5-58.5T280-480q0-83 58.5-141.5T480-680q83 0 141.5 58.5T680-480q0 83-58.5 141.5T480-280ZM200-440H40v-80h160v80Zm720 0H760v-80h160v80ZM440-760v-160h80v160h-80Zm0 720v-160h80v160h-80ZM256-650l-101-97 57-59 96 100-52 56Zm492 496-97-101 53-55 101 97-57 59Zm-98-550 97-101 59 57-100 96-56-52ZM154-212l101-97 55 53-97 101-59-57Z"/></svg>'),
    ];

    return $build;
  }

}
