<?php

/**
 * Outputs a CSV of one-time login URLs.
 */
function one_time_login_csv() {
  drupal_add_http_header('Content-Type', 'text/csv; charset=utf-8');
  drupal_add_http_header('Content-Disposition', 'inline; filename="one_time_login.csv"');
  print t('UID') .','. t('Name') .','. t('Mail') .','. t('URL') .','. t('Expiry') ."\r\n";
  $users = db_query('SELECT * FROM {users} WHERE uid > 0');
  $date = format_date(time() + 86400, 'small');
  foreach ($users as $user) {
    print $user->uid .',"'. $user->name .'","'. $user->mail .'","'. user_pass_reset_url($user) .'","'. ($user->login ? $date : '') ."\"\r\n";
  }
}

