<?php

namespace Drupal\one_time_login_link_admin;

use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\Core\StringTranslation\TranslationInterface;

/**
 * Class HelperService is a helper service.
 */
class HelperService {
  use StringTranslationTrait;

  /**
   * Constructs a new HelperService object.
   */
  public function __construct(TranslationInterface $string_translation) {
    $this->stringTranslation = $string_translation;
  }

  /**
   * Generate second to human-readable format.
   *
   * @int $seconds
   *   Time value in second.
   *
   * @return string
   *   A time string in human-readable format.
   */
  public function secTohr($seconds): string {
    if (is_numeric($seconds)) {
      $hours = floor($seconds / 3600);
      $minutes = floor(($seconds / 60) % 60);
      $seconds = $seconds % 60;
      $response = $hours > 0 ? "$hours hours" : ($minutes > 0 ? "$minutes minutes, $seconds seconds" : "$seconds seconds");
      return $this->t("@res", ['@res' => $response]);
    }
    return $this->t("Invalid time");
  }

}
