(function ($, Drupal, once) {
  Drupal.behaviors.copyToClipboard = {
    attach(context) {
      // Helper function to show a toast message (defined before use to satisfy ESLint)
      function showToast(message) {
        let container = document.querySelector('.toast-container');
        if (!container) {
          container = document.createElement('div');
          container.className =
            'toast-container position-fixed bottom-0 end-0 p-3';
          container.style.zIndex = '1080';
          document.body.appendChild(container);
        }

        const toastWrapper = document.createElement('div');
        toastWrapper.className = 'toast show';
        toastWrapper.setAttribute('role', 'alert');
        toastWrapper.setAttribute('aria-live', 'assertive');
        toastWrapper.setAttribute('aria-atomic', 'true');

        toastWrapper.innerHTML = `
          <div class="toast-header">
            <strong class="me-auto">OneTimeLogin</strong>
            <small class="text-muted">now</small>
            <button type="button" class="btn-close" data-bs-dismiss="toast" aria-label="Close"></button>
          </div>
          <div class="toast-body">${message}</div>
        `;

        container.appendChild(toastWrapper);

        // Auto-dismiss after 3 seconds
        setTimeout(() => {
          toastWrapper.classList.remove('show');
          toastWrapper.classList.add('hide');
          setTimeout(() => toastWrapper.remove(), 500);
        }, 3000);
      }

      // Fallback copy method (defined before use to satisfy ESLint)
      function fallbackCopyText(text) {
        const tempInput = document.createElement('input');
        tempInput.value = text;
        document.body.appendChild(tempInput);
        tempInput.select();
        tempInput.setSelectionRange(0, 99999); // For mobile devices
        try {
          document.execCommand('copy');
          showToast(Drupal.t('Link copied to clipboard!'));
        } catch (err) {
          console.error('Fallback copy failed: ', err);
          showToast(Drupal.t('Copy failed.'));
        }
        document.body.removeChild(tempInput);
      }

      once('copyToClipboard', '#copy-button', context).forEach((el) => {
        el.addEventListener('click', function (e) {
          e.preventDefault();
          const input = document.getElementById('login-link');
          if (input) {
            const text = input.value;

            if (navigator.clipboard && navigator.clipboard.writeText) {
              navigator.clipboard
                .writeText(text)
                .then(() => showToast(Drupal.t('Link copied to clipboard!')))
                .catch((err) => {
                  console.error('Clipboard API failed: ', err);
                  fallbackCopyText(text);
                });
            } else {
              fallbackCopyText(text);
            }
          }
        });
      });
    },
  };
})(jQuery, Drupal, once);
