<?php

declare(strict_types=1);

namespace Drupal\onetimelogin\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure onetimelogin settings for this site.
 */
final class Settings extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'onetimelogin_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['onetimelogin.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $config = $this->config('onetimelogin.settings');

    $form['short_url_settings'] = [
      '#type' => 'details',
      '#title' => $this->t('Short URL Settings'),
      '#open' => TRUE,
    ];

    $form['short_url_settings']['enable_short_url'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable Short URL Generation'),
      '#default_value' => $config->get('enable_short_url'),
      '#description' => $this->t('When enabled, a short URL will be generated automatically for one-time login links.'),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $this->config('onetimelogin.settings')
      ->set('enable_short_url', $form_state->getValue('enable_short_url'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
