## INTRODUCTION

The open_daterange module is an extension of the core Datetime Range field type that makes the end date and time optional when defining a date range. This effectively allows content editors to create "open-ended" or continuous time periods.

The primary use case for this module is:

Ongoing Events/Periods: Defining a period that starts at a known time but continues indefinitely, such as "Membership started on 2024-01-01 to Present."

Cut-Off Dates: Specifying a period where only the start date is initially required, like "Effective since Q1 2024," with the option to fill in the end date later.

Optional Scheduling: Allowing users to specify a start time for a schedule or booking without requiring them to commit to a specific end time.


## REQUIREMENTS

This module requires the following Drupal core module:

- Datetime Range


## INSTALLATION

Install as you would normally install a contributed Drupal module.
See: https://www.drupal.org/node/895232 for further information.


## CONFIGURATION

Add the Field: Navigate to the Manage fields page for your content type or entity and add a new field of type "Open date range".

Configure Field Settings: Configure the field settings (such as date storage format and allowed values) as you would for a standard Date Range field. The field will automatically be set up to treat the end date as optional.

Verify Widget: Ensure the field's widget on the Manage form display page is set to "Open date and time range". This custom widget ensures that the 'End date' form element is marked as non-required in the content editing form.

## MAINTAINERS
Current maintainers for Drupal 10:

Ashley George - https://www.drupal.org/u/ashley-george
