<?php

namespace Drupal\open_daterange\Plugin\Field\FieldType;

use Drupal\Core\Field\Attribute\FieldType;
use Drupal\Core\Field\FieldStorageDefinitionInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\datetime_range\Plugin\Field\FieldType\DateRangeFieldItemList;
use Drupal\datetime_range\Plugin\Field\FieldType\DateRangeItem;

/**
 * Plugin implementation of the 'open daterange' field type.
 */
#[FieldType(
  id: "open_daterange",
  label: new TranslatableMarkup("Open date range"),
  description: [
    new TranslatableMarkup("Ideal for date intervals or cut-off (start/stop date) periods"),
  ],
  category: "date_time",
  default_widget: "open_daterange_default",
  default_formatter: "daterange_default",
  list_class: DateRangeFieldItemList::class,
)]
class OpenDateRangeItem extends DateRangeItem {

  /**
   * {@inheritdoc}
   */
  public static function propertyDefinitions(FieldStorageDefinitionInterface $field_definition) {
    $properties = parent::propertyDefinitions($field_definition);
    $properties['value']->setRequired(FALSE);
    $properties['end_value']->setRequired(FALSE);
    return $properties;
  }

  /**
   * {@inheritdoc}
   */
  public function isEmpty() {
    $start_value = $this->get('value')->getValue();
    $end_value = $this->get('end_value')->getValue();

    // The field is considered empty ONLY IF both the start date AND the end date
    // are NULL or empty strings. If either value is present, the field is NOT empty.
    return (
      ($start_value === NULL || $start_value === '') &&
      ($end_value === NULL || $end_value === '')
    );
  }

}
