<?php

namespace Drupal\open_daterange\Plugin\Field\FieldWidget;

use Drupal\Core\Field\Attribute\FieldWidget;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\datetime_range\Plugin\Field\FieldWidget\DateRangeDefaultWidget;

/**
 * Plugin implementation of the 'open_daterange_default' widget.
 */
#[FieldWidget(
  id: 'open_daterange_default',
  label: new TranslatableMarkup('Open date and time range'),
  field_types: ['open_daterange'],
)]
class OpenDateRangeDefaultWidget extends DateRangeDefaultWidget {

  /**
   * {@inheritdoc}
   */
  public function formElement(FieldItemListInterface $items, $delta, array $element, array &$form, FormStateInterface $form_state) {
    $element = parent::formElement($items, $delta, $element, $form, $form_state);

    $element['end_value']['#required'] = FALSE;
    $element['value']['#required'] = FALSE;

    return $element;
  }

}
