# Open Vocabularies

The Open Vocabularies module allows users to choose how a piece of content will be categorised without having to change the related content type field definition.
It does that by providing:

* An open vocabulary field type
* The possibility to create associations between open vocabulary field types and Drupal categorisation systems, such as Drupal taxonomies, Publication Office vocabularies, or subsets of them.

Once a content type is equipped with an open vocabulary field, users with appropriate access can decide which type of entities that field will able to reference, by creating associations.

## Development setup

You can build the development site by running the following steps:

* Install the Composer dependencies:

```bash
composer install
```

### Using Docker and DDEV

* This project is using [Docker and DDEV](https://ddev.readthedocs.io/en/latest/users/install/) for local development.

* Setup test site by running ddev:

```
$ ddev start
```
* Install dependencies using the following command:
```
$ ddev poser
```
* Symlink the project files into the test site:
```
$ ddev symlink-project
```
* Update configurations to detect expected Drupal and PHP versions:
```
$ ddev config --update
```
* Restart DDEV to apply the changes:
```
$ ddev restart
```
* Install the site using the following command:
```
$ ddev install
```
**Please note:** project files and directories are symlinked within the test site.

If you add a new file or directory in the root of the project, you need to re-run `ddev symlink-project` in order to make
sure they are be correctly symlinked.

Your test site will be available at `./web`.

* Visit the [ddev-drupal-contrib](https://github.com/ddev/ddev-drupal-contrib?tab=readme-ov-file#commands) for available commands to run different tests locally.

## Versioning

We use [SemVer](http://semver.org/) for versioning. For the available versions, see the [tags on this repository](https://git.drupalcode.org/project/open_vocabularies/-/tags).
