/**
 * @file
 * Contains the definition of the OpenAgenda event timetable behaviour.
 */

(function ($, Drupal, drupalSettings) {
  Drupal.behaviors.eventTimetable = {
    attach(context) {
      function navTimings(direction, e) {
        $(e.target)
          .closest('.js_month')
          .removeClass('displayed')
          [direction]()
          .addClass('displayed');
      }

      // Event timetable navigation.
      $('.js_timings .js_next').click(navTimings.bind(null, 'next'));
      $('.js_timings .js_prev').click(navTimings.bind(null, 'prev'));
    },
  };
})(jQuery, Drupal, drupalSettings);
