<?php

namespace Drupal\openagenda;

use Drupal\Core\Site\Settings;
use OpenAgendaSdk\OpenAgendaSdk;
use Drupal\Core\Config\ConfigFactoryInterface;

/**
 * Factory for OpenAgenda SDK.
 */
class OpenagendaSdkFactory {

  public function __construct(
    protected ConfigFactoryInterface $configFactory,
  ) {}

  /**
   * Creates a new OpenAgendaSdk instance.
   *
   * @return \OpenAgendaSdk\OpenAgendaSdk
   *   The OpenAgenda SDK instance.
   */
  public function createInstance() {
    // Get Drupal http client options.
    $options = Settings::get('http_client_config', []);
    $config = $this->configFactory->get('openagenda.settings');
    return new OpenAgendaSdk($config->get('openagenda.public_key'), $options);
  }

}
