<?php

namespace Drupal\openagenda\Plugin\Validation\Constraint;

use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Drupal\openagenda\OpenagendaConnector;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;

/**
 * Validates the OpenagendaPermission constraint.
 */
class OpenagendaPermissionValidator extends ConstraintValidator implements ContainerInjectionInterface {

  public function __construct(
    protected OpenagendaConnector $openAgendaConnector,
  ) {}

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('openagenda.connector'),
    );
  }

  /**
   * {@inheritdoc}
   */
  public function validate($items, Constraint $constraint) {
    /** @var \Drupal\openagenda\Plugin\Field\FieldType\Openagenda $item */
    foreach ($items as $item) {
      $uid = $item->getProperties()['uid']->getValue();
      try {
        $agendaEvents = $this->openAgendaConnector->getAgendaEvents($uid, [], 0, 1);
        if (empty($agendaEvents['success'])) {
          $this->context->addViolation($constraint->forbidden, ['%value' => $uid]);
        }
      }
      catch (\Exception $ex) {
        $this->context->addViolation($constraint->key, []);
      }
    }
  }

}
