<?php

namespace Drupal\openagenda_test;

use OpenAgendaSdk\OpenAgendaSdk;

/**
 * Mock OpenAgendaSdk.
 */
class MockOpenAgendaSdk extends OpenAgendaSdk {

  /**
   * {@inheritdoc}
   */
  public function __construct() {
    // No-op.
  }

  /**
   * Retrieves the state service.
   *
   * @return \Drupal\Core\State\StateInterface
   *   The state service.
   */
  private static function getState() {
    return \Drupal::state();
  }

  /**
   * {@inheritdoc}
   */
  public function getEvents(int $agendaUid, ?array $params = []): string {
    return json_encode(static::getState()->get('openagenda_test.events_response', [
      'success' => TRUE,
      'total' => 0,
      'events' => [],
    ]));
  }

  /**
   * {@inheritdoc}
   */
  public function getAgenda(int $agendaUid): string {
    return json_encode([
      'uid' => $agendaUid,
      'title' => 'Mock Agenda',
    ]);
  }

}
