<?php

namespace Drupal\openagenda_test;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceProviderBase;

/**
 * Overrides the openagenda.sdk service for testing.
 */
class OpenagendaTestServiceProvider extends ServiceProviderBase {

  /**
   * {@inheritdoc}
   */
  public function alter(ContainerBuilder $container) {
    if ($container->hasDefinition('openagenda.sdk')) {
      $container->getDefinition('openagenda.sdk')
        ->setFactory(NULL)
        ->setClass('Drupal\openagenda_test\MockOpenAgendaSdk');
    }
  }

}
