<?php

namespace Drupal\Tests\openagenda\Functional;

/**
 * Tests the display of OpenAgenda fields.
 *
 * @group openagenda
 */
class OpenagendaDisplayTest extends OpenagendaFunctionalTestBase {

  /**
   * Tests that the OpenAgenda field is displayed correctly.
   */
  public function testOpenagendaDisplay() {
    // Create a node with OpenAgenda field.
    $node = $this->drupalCreateNode([
      'type' => 'openagenda',
      'field_openagenda' => [
        'uid' => '123456',
        'events_per_page' => 10,
        'language' => 'en',
        'settings' => '{}',
      ],
    ]);

    // Navigate to the node page.
    $this->drupalGet($node->toUrl());

    // Assert that the mock event is displayed.
    $this->assertSession()->pageTextContains('Mock Event');
    $this->assertSession()->pageTextContains('Mock Description');
    $this->assertSession()->pageTextContains('Mock City');
  }

  /**
   * Tests the "no events" message.
   */
  public function testNoEventsMessage() {
    // Override mock to return no events.
    $this->setupMockSdk([
      'success' => TRUE,
      'total' => 0,
      'events' => [],
    ]);

    $node = $this->drupalCreateNode([
      'type' => 'openagenda',
      'field_openagenda' => [
        'uid' => '123456',
        'events_per_page' => 10,
        'language' => 'en',
        'settings' => '{}',
      ],
    ]);

    $this->drupalGet($node->toUrl());
    $this->assertSession()->pageTextContains('There are no event matching these search parameters.');
  }

}
