<?php

namespace Drupal\Tests\openagenda\Functional;

/**
 * Tests the OpenAgenda filter blocks.
 *
 * @group openagenda
 */
class OpenagendaFiltersTest extends OpenagendaFunctionalTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['block'];

  /**
   * Tests the cities filter block display.
   */
  public function testCitiesFilterBlock() {
    // Create a node with OpenAgenda field.
    $node = $this->drupalCreateNode([
      'type' => 'openagenda',
      'field_openagenda' => [
        'uid' => '123456',
        'events_per_page' => 10,
        'language' => 'en',
        'settings' => '{}',
      ],
    ]);

    // Place the cities filter block.
    $this->drupalPlaceBlock('openagenda_cities_filter_block', [
      'label' => 'Cities Filter',
      'id' => 'cities_filter',
      'context_mapping' => [
        'node' => '@node.node_route_context:node',
      ],
    ]);

    // Navigate to the node page.
    $this->drupalGet($node->toUrl());
    // Assert that the block is present.
    $this->assertSession()->elementExists('css', '.oa-cities-filter');
    $this->assertSession()->elementAttributeContains('css', '.oa-cities-filter', 'data-oa-filter-params', '"name":"city"');

    // Setup mock response with aggregations for the filter callback.
    $response = [
      'success' => TRUE,
      'total' => 2,
      'aggregations' => [
        'city' => [
          ['key' => 'Paris', 'count' => 1],
          ['key' => 'Lyon', 'count' => 1],
        ],
      ],
      'events' => [],
    ];
    $this->setupMockSdk($response);

    // Verify that the filters callback returns the expected JSON.
    $this->drupalGet('/node/' . $node->id() . '/filters');
    $this->assertSession()->statusCodeEquals(200);
    $this->assertSession()->responseContains('"key":"Paris"');
    $this->assertSession()->responseContains('"key":"Lyon"');
  }

  /**
   * Tests that the search filter block is displayed correctly.
   */
  public function testSearchFilterBlock() {
    // Create a node with OpenAgenda field.
    $node = $this->drupalCreateNode([
      'type' => 'openagenda',
      'field_openagenda' => [
        'uid' => '123456',
        'events_per_page' => 10,
        'language' => 'en',
        'settings' => '{}',
      ],
    ]);

    // Place the search filter block.
    $this->drupalPlaceBlock('openagenda_search_filter_block', [
      'label' => 'Search Filter',
      'id' => 'search_filter',
      'context_mapping' => [
        'node' => '@node.node_route_context:node',
      ],
    ]);

    // Navigate to the node page.
    $this->drupalGet($node->toUrl());

    // Assert that the block is present.
    $this->assertSession()->elementExists('css', '.oa-search-filter');
    $this->assertSession()->elementAttributeContains('css', '.oa-search-filter', 'data-oa-filter-params', '"name":"search"');
  }

}
