<?php

namespace Drupal\Tests\openagenda\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Base class for OpenAgenda functional tests.
 */
abstract class OpenagendaFunctionalTestBase extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'openagenda',
    'openagenda_test',
  ];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    // The openagenda module provides the 'openagenda' content type
    // and 'field_openagenda' field via its config/install.
    $this->setupMockSdk();
  }

  /**
   * Sets up the mock SDK with default responses.
   */
  protected function setupMockSdk($response = NULL) {
    if ($response === NULL) {
      $response = [
        'success' => TRUE,
        'total' => 1,
        'events' => [
          [
            'uid' => 123,
            'title' => ['en' => 'Mock Event'],
            'description' => ['en' => 'Mock Description'],
            'dateRange' => ['en' => 'January 1st, 2026'],
            'slug' => 'mock-event',
            'image' => NULL,
            'location' => [
              'city' => 'Mock City',
            ],
          ],
        ],
      ];
    }

    $this->container->get('state')->set('openagenda_test.events_response', $response);
  }

}
