<?php

namespace Drupal\openai_batch\Batch;

/**
 * Batch operations for OpenAI Batch module.
 */
class OpenAiBatchOperations {

  /**
   * Fetches the remote batches from OpenAI.
   */
  public static function fetchRemoteBatchesOperation($fetch_all, &$context) {
    $storage = \Drupal::entityTypeManager()->getStorage('openai_batch_request');
    $openai_batch_service = \Drupal::getContainer()->get('openai_batch.batch_service');
    $sandbox = &$context['sandbox'];
    if (!$sandbox) {
      $sandbox['progress'] = 0;
      $context['finished'] = 0;
      $sandbox['last_id'] = NULL;
    }
    $client = $openai_batch_service->getClient();
    if ($sandbox['last_id']) {
      $response = $client->batches()->list(['limit' => 100, 'after' => $sandbox['last_id']]);
    }
    else {
      $response = $client->batches()->list(['limit' => 100]);
    }

    if ($fetch_all) {
      foreach ($response->data as $batch) {
        $context['results'][] = $batch;
      }
    }
    else {
      $q = $storage->getQuery();
      $q->accessCheck(FALSE);
      $local_entity_ids = $q->execute();
      foreach ($response->data as $batch) {
        if (in_array($batch->id, $local_entity_ids)) {
          $context['results'][] = $batch;
        }
      }
    }
    if (!$response->hasMore) {
      $context['finished'] = 1;
      $sandbox['last_id'] = NULL;
    }
    else {
      $context['finished'] = 0;
      $sandbox['last_id'] = $response->lastId;
    }

    $context['message'] = t('Fetching batches');
  }

  /**
   * Updates local entities with remote data.
   */
  public static function updateLocalEntitiesOperation($create_missing, &$context) {
    $storage = \Drupal::entityTypeManager()->getStorage('openai_batch_request');
    $sandbox = &$context['sandbox'];
    if (!$sandbox) {
      $sandbox['progress'] = 0;
      $context['finished'] = 0;
      $sandbox['remote_batches'] = $context["results"];
      $sandbox['max'] = count($sandbox['remote_batches']);
    }

    if (!empty($sandbox['remote_batches'])) {
      $batch = array_shift($sandbox['remote_batches']);
      $batch_id = $batch->id;
      $batch_entity = $storage->load($batch_id);
      if ($batch_entity) {
        $batch_service = \Drupal::getContainer()->get('openai_batch.batch_service');
        $batch_service->updateOpenAiBatchRequestEntity(batch_response: $batch, batch_entity: $batch_entity);
      }
      elseif ($create_missing) {
        $batch_entity = $storage->create([
          'id' => $batch_id,
          'status' => $batch->status,
          'endpoint' => $batch->endpoint,
          'created_at' => $batch->createdAt,
          'input_file_id' => $batch->inputFileId,
          'output_file_id' => $batch->outputFileId,
          'in_progress_at' => $batch->inProgressAt,
          'expires_at' => $batch->expiresAt,
          'finalizing_at' => $batch->finalizingAt,
          'completed_at' => $batch->completedAt,
          'failed_at' => $batch->failedAt,
          'expired_at' => $batch->expiredAt,
          'cancelling_at' => $batch->cancellingAt,
          'cancelled_at' => $batch->cancelledAt,
        ]);
        $batch_entity->save();
      }
      $sandbox['progress']++;
      $context['finished'] = $sandbox['progress'] / $sandbox['max'];
    }

    if (empty($sandbox['remote_batches'])) {
      $context['finished'] = 1;
    }
  }

  /**
   * Callback for when the batch is finished.
   */
  public static function refreshBatchesOperationFinished($success, array $results, array $operations) {
    // @todo what else to do here?
  }

}
