<?php

namespace Drupal\openai_batch;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityListBuilder;

/**
 * Provides a list controller for the openai batch request entity type.
 */
final class OpenAiBatchRequestListBuilder extends EntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader(): array {
    $header['id'] = $this->t('ID');
    $header['status'] = $this->t('Status');
    $header['downloaded'] = $this->t('Downloaded');
    $header['processed'] = $this->t('Processed');
    $header['autosync'] = $this->t('Autosync');
    $header['processor'] = $this->t('Processor');
    $header['endpoint'] = $this->t('Endpoint');
    $header['uid'] = $this->t('Author');
    $header['created'] = $this->t('Created');
    $header['changed'] = $this->t('Updated');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity): array {
    /** @var \Drupal\openai_batch\Entity\OpenAiBatchRequest $entity */
    $row['id'] = $entity->toLink();
    $row['status'] = $entity->get('status')->value;
    $row['downloaded'] = $entity->get('downloaded')->value ? $this->t('Yes') : $this->t('No');
    $row['processed'] = $entity->get('processed')->value ? $this->t('Yes') : $this->t('No');
    $row['autosync'] = $entity->get('autosync')->value ? $this->t('Yes') : $this->t('No');
    $row['processor'] = $entity->get('processor')->value;
    $row['endpoint'] = $entity->get('endpoint')->value;
    $username_options = [
      'label' => 'hidden',
      'settings' => ['link' => $entity->get('uid')->entity->isAuthenticated()],
    ];
    $row['uid']['data'] = $entity->get('uid')->view($username_options);
    $row['created']['data'] = $entity->get('created')->view(['label' => 'hidden']);
    $row['changed']['data'] = $entity->get('changed')->view(['label' => 'hidden']);
    return $row + parent::buildRow($entity);
  }

}
