<?php

namespace Drupal\openai_batch\Plugin\Derivative;

use Drupal\Component\Plugin\Derivative\DeriverBase;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Deriver that creates a VBO action for each OpenAI Batch processor plugin.
 */
class OpenAiBatchVBOActionDerivative extends DeriverBase {

  /**
   * {@inheritdoc}
   */
  public function getDerivativeDefinitions($base_plugin_definition) {
    $batch_processor_manager = \Drupal::service('plugin.manager.openai_batch_processor');
    $batch_processors = $batch_processor_manager->getDefinitions();

    foreach ($batch_processors as $plugin_id => $plugin_definition) {
      // Generate a unique derivative for each OpenAiBatchProcessor plugin.
      $this->derivatives[$plugin_id] = $base_plugin_definition;

      // Unique ID for the derivative plugin.
      $this->derivatives[$plugin_id]['id'] = 'openai_batch_vbo_action:' . $plugin_id;

      // Human-readable label for the action.
      $this->derivatives[$plugin_id]['label'] = $this->t('OpenAI Batch Process: @plugin', [
        '@plugin' => $plugin_definition['label'],
      ]);

      // Pass the OpenAiBatchProcessor plugin ID to the action.
      $this->derivatives[$plugin_id]['openai_batch_processor_id'] = $plugin_id;
    }

    return $this->derivatives;
  }

  use StringTranslationTrait;

}
